'SimpleEvents 1.5 - by uziq - June 29 2004
'This is an add-on script for SimpleCalendar 2.0, but your calendar must use the Link_SimpleEvents_GridPosition or Link_SimpleEvents_DayNumber functions.
'http://www.geocities.com/samurize@swbell.net/samurize.html
'uziq@hotmail.com



'========================================================================================================
'== USER EDITABLE VARIABLES =============================================================================
'========================================================================================================
 'event text variables
    'ShowMonth = 1			'0 or 1	(NOT YET WORKING!)
    MonthAbbv_Length = 0    '0 = default abbrevation length : or you can specify a length by using any number > 0
    MonthAbbv_Case = 0      '0 = default spelling : 1 = make first letter uppercase : 2 = make all letters uppercase
    MonthAbbv_RemovePeriod = 1 '0 = do not remove period : 1 = remove period (only applies when the abbreviated month has a period)
    TodaysIndicator = "()"  'Enter a string that's one or two characters long (if you want today's date to stand out more)
    TodaysText = "Today!"   '"0" = do not indicate today's date in the event text : Otherwise, the event text will display whatever else you put.
	SingleDigitDayStr = "0" 'add this character before single digit days (or just use empty quotes "" if you don't want anything)
    DaysBehind = 1          'any number >= 0 : This is how many days behind today's date to show event text.
    DaysAhead = 30          'any number >= 0 : This is how many days ahead of today's date to show event text.
    Hyphen = CHR(183)       'This the seperator between the date and the text. CHR(183) is a bullet.

 'event handling
    DeleteCommand = "DEL"   'type in quotes whatever you want the command to be.






'========================================================================================================
'== DO NOT EDIT BELOW THIS LINE =========================================================================
'========================================================================================================
PUBLIC EventCount, EventLineNumber(), EventYear(), EventMonth(), EventDay(), EventText()
PUBLIC ExtractedText, LineNumber
PUBLIC TestFileText, AllEvents  'for debugging
SET FSO = CREATEOBJECT("Scripting.FileSystemObject")

SamurizeDir                 = CREATEOBJECT("WScript.Shell").RegRead("HKEY_CURRENT_USER\Software\Serious Samurize\General\DirPath")
Path                        = SamurizeDir & "Scripts\SimpleEvents\"
EventsFile                  = Path & "Events.dat"
EventHighlightHolidaysFile  = Path & "EventHighlight_Holidays.txt"
EventHighlightBirthdaysFile = Path & "EventHighlight_Birthdays.txt"
EventHighlightRemindersFile = Path & "EventHighlight_Reminders.txt"
EventHighlightAllFile       = Path & "EventHighlight_All.txt"
EventTextHolidaysFile       = Path & "EventText_Holidays.txt"
EventTextBirthdaysFile      = Path & "EventText_Birthdays.txt"
EventTextRemindersFile      = Path & "EventText_Reminders.txt"
EventTextAllFile            = Path & "EventText_All.txt"
ViewingMonthFile            = SamurizeDir & "plugins\SimpleCalendar_ViewingMonth.txt"
TestFile                    = Path & "Test.dat"     'for debugging

IF FSO.FolderExists(Path) = 0 THEN FSO.CreateFolder(Path)
'If FSO.FileExists(EventsFile) = 0 Then FSO.CreateTextFile(EventsFile).Write("[Reminders]" & VBCRLF & DAY(NOW) & "/" & MONTH(NOW) & "/" & YEAR(NOW) & "=" & CHR(34) & "You should copy the supplied Events.dat over this file" & CHR(34) & VBCRLF & "[/Reminders]")
IF FSO.FileExists(EventsFile) = 0 THEN
	FSO.CreateTextFile(EventsFile).WRITE("[Reminders]" & VBCRLF & DAY(NOW) & "/" & MONTH(NOW) & "/" & YEAR(NOW) & "=" & CHR(34) & "Events.dat file created!" & CHR(34) & VBCRLF & "[/Reminders]")
	SET File = FSO.GetFile(EventsFile)
	File.attributes = File.attributes - 32     'removes the file's archive flag so SimpleCalendar can detect when a new Event.dat file is being used.
END IF



'========================================================================================================
'== Get the ViewingDate =================================================================================
'========================================================================================================
PUBLIC MonthShift, ViewingDay, ViewingMonth, ViewingYear, ViewingDate
IF FSO.FileExists(ViewingMonthFile) THEN
	SET DataFileStream = FSO.OpenTextFile(ViewingMonthFile, 1)
	DO WHILE DataFileStream.AtEndOfStream <> TRUE
		MasterViewingDate = TRIM(DataFileStream.ReadLine)
	LOOP
	DataFileStream.Close
	IF MasterViewingDate <> "" THEN
		ViewingMonth = INT(MID(MasterViewingDate, 1, 2))
		ViewingYear  = INT(MID(MasterViewingDate, 7, 4))
		IF ViewingMonth = MONTH(NOW) AND ViewingYear = YEAR(NOW) THEN
			ViewingDay = DAY(NOW)
		ELSE
			ViewingDay = 1
		END IF
	END IF
ELSE
	ViewingDay = DAY(NOW)
	ViewingMonth = MONTH(NOW)
	ViewingYear = YEAR(NOW)
END IF

ViewingDate = DATESERIAL(ViewingYear, ViewingMonth, ViewingDay)


'========================================================================================================
'========================================================================================================
'========================================================================================================
PUBLIC TheDate, TheYear, TheMonth, TheDay
CommandArg = Wscript.arguments.Item(0)  'the command argument (switch)
IF LEFT(CommandArg, 3) = "Day" or LEFT(CommandArg, 3) = "Pos" THEN
	CP = MID(CommandArg, 4, LEN(CommandArg) - 3)	'trim off the text
	MonthShift = CP \ 100			'return .. ,-1, 0, 1, ..
	CP = ABS(CP - (MonthShift * 100))	'return a number between 1-42

    'first get the month/year based on the monthshift
  	TheDate  = DATEADD("m", MonthShift, DATESERIAL(ViewingYear, ViewingMonth, "1"))
	TheMonth = MONTH(TheDate)
	TheYear  = YEAR(TheDate)

	IF LEFT(CommandArg, 3) = "Day" THEN	EnterReminder("ActualDay")
	IF LEFT(CommandArg, 3) = "Pos" THEN	EnterReminder("GridPosition")
END IF


IF CommandArg = "0" THEN RefreshCalendar	'refresh the files


'IF Isnumeric(CP) THEN
'	IF CommandArg = "100" THEN RefreshCalendar
'ELSE
	'IF INSTR(CP, "Weekday") THEN
	'	CP = MID(CP, 8, LEN(CP))
	'	wscript.echo "You clicked on " & WEEKDAYNAME(CP, 0, 0) & " but this version does not support Weekday events."
	'	CP = CP + 900
	'END IF
'END IF




'========================================================================================================
'========================================================================================================
'========================================================================================================
PRIVATE FUNCTION RefreshCalendar()
	ReadDataFile "Holidays", 31, 31, ViewingDay, ViewingMonth, ViewingYear
	SortAllEvents
	FSO.CreateTextFile(EventHighlightHolidaysFile, 1).WRITE(HighlightDays)

	ReadDataFile "Birthdays", 31, 31, ViewingDay, ViewingMonth, ViewingYear
	SortAllEvents
	FSO.CreateTextFile(EventHighlightBirthdaysFile, 1).WRITE(HighlightDays)

	ReadDataFile "Reminders", 31, 31, ViewingDay, ViewingMonth, ViewingYear
	SortAllEvents
	FSO.CreateTextFile(EventHighlightRemindersFile, 1).WRITE(HighlightDays)

	ReadDataFile "Holidays", 31, 31, ViewingDay, ViewingMonth, ViewingYear
	ReadDataFile "Birthdays", 31, 31, ViewingDay, ViewingMonth, ViewingYear
	ReadDataFile "Reminders", 31, 31, ViewingDay, ViewingMonth, ViewingYear
	SortAllEvents
	FSO.CreateTextFile(EventHighlightAllFile, 1).WRITE(HighlightDays)

'-----

	ReadDataFile "Holidays", DaysBehind, DaysAhead, ViewingDay, ViewingMonth, ViewingYear
	SortAllEvents
	GetEventTextReady TodaysText, DaysBehind, DaysAhead    'format the event text for display
	FSO.CreateTextFile(EventTextHolidaysFile, 1).WRITE(ExtractedText)

	ReadDataFile "Birthdays", DaysBehind, DaysAhead, ViewingDay, ViewingMonth, ViewingYear
	SortAllEvents
	GetEventTextReady TodaysText, DaysBehind, DaysAhead    'format the event text for display
	FSO.CreateTextFile(EventTextBirthdaysFile, 1).WRITE(ExtractedText)

	ReadDataFile "Reminders", DaysBehind, DaysAhead, ViewingDay, ViewingMonth, ViewingYear
	SortAllEvents
	GetEventTextReady TodaysText, DaysBehind, DaysAhead    'format the event text for display
	FSO.CreateTextFile(EventTextRemindersFile, 1).WRITE(ExtractedText)

	ReadDataFile "Holidays", DaysBehind, DaysAhead, ViewingDay, ViewingMonth, ViewingYear
	ReadDataFile "Birthdays", DaysBehind, DaysAhead, ViewingDay, ViewingMonth, ViewingYear
	ReadDataFile "Reminders", DaysBehind, DaysAhead, ViewingDay, ViewingMonth, ViewingYear
	SortAllEvents
	GetEventTextReady TodaysText, DaysBehind, DaysAhead    'format the event text for display
	FSO.CreateTextFile(EventTextAllFile, 1).WRITE(ExtractedText)
END FUNCTION


'========================================================================================================
'========================================================================================================
'========================================================================================================
PRIVATE FUNCTION HighlightDays()
	FirstDayOfMonth = DATEPART("w", DATESERIAL(ViewingYear, ViewingMonth, "1"), 0)
    
    HighlightDays   = VBTAB  'number
    HighlightDays2  = VBTAB  'underline
    HighlightDays3  = VBTAB  'parenthesis
    HighlightDays4  = VBTAB  'brackets
    HighlightDays5  = VBTAB  'hollow square (Webdings)
    HighlightDays6  = VBTAB  'filled square (Webdings)
    HighlightDays7  = VBTAB  'hollow circle (Arial)
    HighlightDays8  = VBTAB  'filled circle (Webdings)
    HighlightDays9  = VBTAB  'asterisk (Webdings)
    HighlightDays10 = VBTAB  'rounded hollow rectangle (Wingdings 2)
    HighlightDays11 = VBTAB  'upper-left triangle (Wingdings 3)

	FOR x = 1 TO 42
	
		IF x < FirstDayOfMonth THEN
			HighlightDays   = HighlightDays   & " " & VBTAB
			HighlightDays2  = HighlightDays2  & " " & VBTAB
			HighlightDays3  = HighlightDays3  & " " & VBTAB
			HighlightDays4  = HighlightDays4  & " " & VBTAB
			HighlightDays5  = HighlightDays5  & " " & VBTAB
			HighlightDays6  = HighlightDays6  & " " & VBTAB
			HighlightDays7  = HighlightDays7  & " " & VBTAB
			HighlightDays8  = HighlightDays8  & " " & VBTAB
			HighlightDays9  = HighlightDays9  & " " & VBTAB
			HighlightDays10 = HighlightDays10 & " " & VBTAB
			HighlightDays11 = HighlightDays11 & " " & VBTAB
			offset = x
			DidOne = 1
		ELSE
			FOR y = 1 TO EventCount
				IF EventDay(y) = x - offset THEN
					IF EventMonth(y) = ViewingMonth AND EventDay(y) > LastEventDay THEN
						IF LEN(EventDay(y)) = 1 THEN HighlightDays = HighlightDays & " "
						HighlightDays = HighlightDays & EventDay(y) & VBTAB
						HighlightDays2 = HighlightDays2 & "__" & VBTAB
						HighlightDays3 = HighlightDays3 & "(   )" & VBTAB
						HighlightDays4 = HighlightDays4 & "[   ]" & VBTAB
						HighlightDays5 = HighlightDays5 & "c" & VBTAB
						HighlightDays6 = HighlightDays6 & "g" & VBTAB
						HighlightDays7 = HighlightDays7 & "O" & VBTAB
						HighlightDays8 = HighlightDays8 & "n" & VBTAB
						HighlightDays9 = HighlightDays9 & "*" & VBTAB
						HighlightDays10 = HighlightDays10 & "5" & VBTAB
						HighlightDays11 = HighlightDays11 & "z" & VBTAB
						LastEventDay = EventDay(y)
						DidOne = 1
					END IF
				END IF
			NEXT
		END IF
		
		IF DidOne = 0 THEN
			HighlightDays = HighlightDays & " " & VBTAB
			HighlightDays2 = HighlightDays2 & " " & VBTAB
			HighlightDays3 = HighlightDays3 & " " & VBTAB
			HighlightDays4 = HighlightDays4 & " " & VBTAB
			HighlightDays5 = HighlightDays5 & " " & VBTAB
			HighlightDays6 = HighlightDays6 & " " & VBTAB
			HighlightDays7 = HighlightDays7 & " " & VBTAB
			HighlightDays8 = HighlightDays8 & " " & VBTAB
			HighlightDays9 = HighlightDays9 & " " & VBTAB
			HighlightDays10 = HighlightDays10 & " " & VBTAB
			HighlightDays11 = HighlightDays11 & " " & VBTAB
		END IF
		DidOne = 0
		
		IF x MOD 7 = 0 THEN
			HighlightDays = HighlightDays & VBCRLF
			HighlightDays2 = HighlightDays2 & VBCRLF
			HighlightDays3 = HighlightDays3 & VBCRLF
			HighlightDays4 = HighlightDays4 & VBCRLF
			HighlightDays5 = HighlightDays5 & VBCRLF
			HighlightDays6 = HighlightDays6 & VBCRLF
			HighlightDays7 = HighlightDays7 & VBCRLF
			HighlightDays8 = HighlightDays8 & VBCRLF
			HighlightDays9 = HighlightDays9 & VBCRLF
			HighlightDays10 = HighlightDays10 & VBCRLF
			HighlightDays11 = HighlightDays11 & VBCRLF
			IF x <> 42 THEN
				HighlightDays = HighlightDays & VBTAB
				HighlightDays2 = HighlightDays2 & VBTAB
				HighlightDays3 = HighlightDays3 & VBTAB
				HighlightDays4 = HighlightDays4 & VBTAB
				HighlightDays5 = HighlightDays5 & VBTAB
				HighlightDays6 = HighlightDays6 & VBTAB
				HighlightDays7 = HighlightDays7 & VBTAB
				HighlightDays8 = HighlightDays8 & VBTAB
				HighlightDays9 = HighlightDays9 & VBTAB
				HighlightDays10 = HighlightDays10 & VBTAB
				HighlightDays11 = HighlightDays11 & VBTAB
			END IF
		END IF
	
	NEXT

	HighlightDays = HighlightDays & _
					HighlightDays2 & _
					HighlightDays3 & _
					HighlightDays4 & _
					HighlightDays5 & _
					HighlightDays6 & _
					HighlightDays7 & _
					HighlightDays8 & _
					HighlightDays9 & _
					HighlightDays10 & _
					HighlightDays11


EventCount = 0    'resets the event count
END FUNCTION


'========================================================================================================
'========================================================================================================
'========================================================================================================
PRIVATE FUNCTION ReadDataFile(EventType, DaysBehind, DaysAhead, TheDay, TheMonth, TheYear)
SET DataFileStream = FSO.OpenTextFile(EventsFile, 1)

DO WHILE DataFileStream.AtEndOfStream <> TRUE
 LineCount = LineCount + 1
 EventLine = TRIM(DataFileStream.ReadLine)

 IF LEFT(EventLine, 1) <> "'" THEN
  IF INSTR(EventLine, "[" & EventType & "]") THEN EventTypeFound = 1 : LineNumber = LineCount
  IF EventTypeFound THEN
    IF EventType = "Holidays" THEN  'search for the locale code
     DO WHILE LocaleCodeFound = 0 AND DataFileStream.AtEndOfStream <> TRUE
      LineCount = LineCount + 1
      EventLine = TRIM(DataFileStream.ReadLine)
      IF LEFT(EventLine, 1) <> "'" AND INSTR(EventLine, "[" & GetLocale & "]") THEN LocaleCodeFound = 1
     LOOP
    END IF

        IF INSTR(EventLine, "[/" & GetLocale & "]") THEN EXIT DO
        IF INSTR(EventLine, "[/" & EventType & "]") THEN EXIT DO

    Slash1 = INSTR(EventLine, "/")
    Slash2 = INSTR(Slash1+1, EventLine, "/")
    Pound = INSTR(EventLine, "#")
    Equals = INSTR(Slash1+1, EventLine, "=")
    Quote1 = INSTR(Equals+1, EventLine, CHR(34))    'CHR(34) = "
    Quote2 = INSTR(Quote1+1, EventLine, CHR(34))    'CHR(34) = "
    IF Slash2 > Equals THEN Slash2 = 0  'ignore slashes past the equals sign
    IF Pound > Slash1 THEN Pound = 0    'ignora pounds past the first slash

    IF 0 < Slash1 AND Slash1 < Equals AND Equals < Quote1 AND Quote1 < Quote2 THEN  'this is a valid event
     EventCount = EventCount + 1
     oldLineNumber = LineNumber
     LineNumber = LineCount
     REDIM PRESERVE EventLineNumber(EventCount), EventYear(EventCount), EventMonth(EventCount), EventDay(EventCount), EventText(EventCount) 'make the array bigger
     EventLineNumber(EventCount) = LineCount
     EventText(EventCount) = MID(EventLine, Quote1+1, Quote2-Quote1-1)

    IF Pound THEN
     Occurance = CINT(MID(EventLine, Pound-1, 1))
     DayofWeek = CINT(MID(EventLine, Pound+1, 1))
    ELSE
     EventDay(EventCount) = CINT(MID(EventLine, 1, Slash1-1))
    END IF

     IF Slash2 THEN     'there is a predefined year ------------------------
      EventMonth(EventCount) = Month("26/" & MID(EventLine, Slash1+1, Slash2-Slash1-1))
      EventYear(EventCount) = CINT(MID(EventLine, Slash2+1, Equals-Slash2-1))
      IF Pound THEN
        FirstDayOfMonth = DATEPART("w", DATESERIAL(EventYear(EventCount), EventMonth(EventCount), "1"), 0)
        IF DayofWeek >= FirstDayOfMonth THEN FirstOccur = 1+(DayofWeek-FirstDayOfMonth)
        IF DayofWeek < FirstDayOfMonth THEN FirstOccur = 8-(FirstDayOfMonth-DayofWeek)
        EventDay(EventCount) = FirstOccur + (7*Occurance) - 7
      END IF
      TestDiff = DateDiff("d", DATESERIAL(TheYear, TheMonth, TheDay), DATESERIAL(EventYear(EventCount), EventMonth(EventCount), EventDay(EventCount)), 0)
      IF (-CINT(DaysBehind) <= TestDiff AND TestDiff <= CINT(DaysAhead)) = False THEN     'check if event's year is too far away or not
        EventLineNumber(EventCount) = "" : EventDay(EventCount) = "" : EventMonth(EventCount) = "" : EventYear(EventCount) = "" : EventText(EventCount) = ""
        EventCount = EventCount - 1
        LineNumber = oldLineNumber
      ELSE
        AllEvents = AllEvents & EventCount & ": " & EventDay(EventCount) & "/" & EventMonth(EventCount) & "/" & EventYear(EventCount) & "=" & EventText(EventCount) & VBCRLF
      END IF
     ELSE 'there is no predefined year ------------------------
      EventMonth(EventCount) = Month("26/" & MID(EventLine, Slash1+1, Equals-Slash1-1))
        IF Pound THEN
           FOR z = -1 TO 1 'test past year, this year, and next year
             'should check this year, last year, and next year (in that order)?
              IF EventMonth(EventCount) = TheMonth THEN EventYear(EventCount) = TheYear
              IF EventMonth(EventCount) <> TheMonth THEN EventYear(EventCount) = Year(DATESERIAL(TheYear+z, TheMonth, TheDay))
              FirstDayOfMonth = DATEPART("w", DATESERIAL(EventYear(EventCount), EventMonth(EventCount), "1"), 0)
              IF DayofWeek >= FirstDayOfMonth THEN FirstOccur = 1+(DayofWeek-FirstDayOfMonth)
              IF DayofWeek < FirstDayOfMonth THEN FirstOccur = 8-(FirstDayOfMonth-DayofWeek)
              EventDay(EventCount) = FirstOccur + (7*Occurance) - 7
              TestDiff = DateDiff("d", DATESERIAL(TheYear, TheMonth, TheDay), DATESERIAL(EventYear(EventCount), EventMonth(EventCount), EventDay(EventCount)), 0)
              IF -CINT(DaysBehind) <= TestDiff AND TestDiff <= CINT(DaysAhead) THEN
               AllEvents = AllEvents & EventCount & ": " & EventDay(EventCount) & "/" & EventMonth(EventCount) & "/" & EventYear(EventCount) & "=" & EventText(EventCount) & VBCRLF
'--------test line to ignore floating events from year-1 so inserted events will be placed properly
               IF z = -1 THEN LineNumber = oldLineNumber
               EXIT FOR
              ELSE
               IF z = 1 THEN 'all the years have been tested and this event is too far away
                    EventLineNumber(EventCount) = "" : EventDay(EventCount) = "" : EventMonth(EventCount) = "" : EventYear(EventCount) = "" : EventText(EventCount) = ""
                    EventCount = EventCount - 1
                LineNumber = oldLineNumber
               END IF
              END IF
           NEXT
        ELSE
           FOR z = -1 TO 1 'test past year, this year, and next year
              IF EventMonth(EventCount) = TheMonth THEN EventYear(EventCount) = TheYear
              IF EventMonth(EventCount) <> TheMonth THEN EventYear(EventCount) = Year(DATESERIAL(TheYear+z, TheMonth, TheDay))
              TestDiff = DateDiff("d", DATESERIAL(TheYear, TheMonth, TheDay), DATESERIAL(EventYear(EventCount), EventMonth(EventCount), EventDay(EventCount)), 0)
               IF -CINT(DaysBehind) <= TestDiff AND TestDiff <= CINT(DaysAhead) THEN
                AllEvents = AllEvents & EventCount & ": " & EventDay(EventCount) & "/" & EventMonth(EventCount) & "/" & EventYear(EventCount) & "=" & EventText(EventCount) & VBCRLF
'--------test line to ignore floating events from year-1 so inserted events will be placed properly
                IF z = -1 THEN LineNumber = oldLineNumber
                EXIT FOR
               ELSE
                IF z = 1 THEN 'all the years have been tested and this event is too far away
                     EventLineNumber(EventCount) = "" : EventDay(EventCount) = "" : EventMonth(EventCount) = "" : EventYear(EventCount) = "" : EventText(EventCount) = ""
                     EventCount = EventCount - 1
                 LineNumber = oldLineNumber
                END IF
               END IF
           NEXT
        END IF 'end Pound check
     END IF 'end Slash2 check
    END IF 'end of valid event
  END IF 'end of EventTypeFound
 END IF 'end of REM check
LOOP


DataFileStream.Close
'FSO.CreateTextFile(TestFile, 1).Write(EventCount & " events total:" & VBCRLF & AllEvents)
END FUNCTION


'========================================================================================================
'========================================================================================================
'========================================================================================================
PRIVATE FUNCTION SortAllEvents()    'this combines and sorts all events (Holidays, Birthdays, and Reminders)
FOR z = 1 TO EventCount
FOR a = EventCount TO 2 STEP -1
 PreviousEventDate = DATESERIAL(EventYear(a-1), EventMonth(a-1), EventDay(a-1))
 CurrentEventDate = DATESERIAL(EventYear(a), EventMonth(a), EventDay(a))
 IF CurrentEventDate < PreviousEventDate THEN
  CurrentEventLineNumber = EventLineNumber(a)
  CurrentEventDay = EventDay(a)
  CurrentEventMonth = EventMonth(a)
  CurrentEventYear = EventYear(a)
  CurrentEventText = EventText(a)
  EventLineNumber(a) = EventLineNumber(a-1)
  EventDay(a) = EventDay(a-1)
  EventMonth(a) = EventMonth(a-1)
  EventYear(a) = EventYear(a-1)
  EventText(a) = EventText(a-1)
  EventLineNumber(a-1) = CurrentEventLineNumber
  EventDay(a-1) = CurrentEventDay
  EventMonth(a-1) = CurrentEventMonth
  EventYear(a-1) = CurrentEventYear
  EventText(a-1) = CurrentEventText
 END IF
NEXT
NEXT

'for a = 1 to EventCount
'AllEvents = AllEvents & EventDay(a) & "/" & EventMonth(a) & "/" & EventYear(a) & " - " & EventText(a) & VBCRLF
'next
'FSO.CreateTextFile(TestFile, 1).Write(PreAllEvents & VBCRLF & AllEvents)
END FUNCTION


'========================================================================================================
'========================================================================================================
'========================================================================================================
PRIVATE FUNCTION GetEventTextReady(TodaysText, DaysBehind, DaysAhead)
IF MonthAbbv_Case = 2 THEN	'do the abbreviate month
 MonthStr = UCASE(MONTHNAME(MONTH(NOW), 1))
 IF MonthAbbv_Length <> 0 THEN
  IF LEN(MonthStr) < MonthAbbv_Length THEN MonthStr = UCASE(LEFT(MONTHNAME(MONTH(NOW)), MonthAbbv_Length))
  IF LEN(MonthStr) > MonthAbbv_Length THEN MonthStr = UCASE(LEFT(MONTHNAME(MONTH(NOW), 1), MonthAbbv_Length))
 END IF
ELSEIF MonthAbbv_Case = 1 THEN
 MonthStr = UCASE(LEFT(MONTHNAME(MONTH(NOW), 1), 1)) & MID(MONTHNAME(MONTH(NOW), 1), 2, LEN(MONTHNAME(MONTH(NOW), 1))-1)
 IF MonthAbbv_Length <> 0 THEN
  IF LEN(MonthStr) < MonthAbbv_Length THEN MonthStr = UCASE(LEFT(MONTHNAME(MONTH(NOW)), 1)) & MID(MONTHNAME(MONTH(NOW)), 2, MonthAbbv_Length-1)
  IF LEN(MonthStr) > MonthAbbv_Length THEN MonthStr = UCASE(LEFT(MONTHNAME(MONTH(NOW), 1), 1)) & MID(MONTHNAME(MONTH(NOW), 1), 2, MonthAbbv_Length-1)
 END IF
ELSE
 MonthStr = MONTHNAME(MONTH(NOW), 1)
 IF MonthAbbv_Length <> 0 THEN
  IF LEN(MonthStr) < MonthAbbv_Length THEN MonthStr = LEFT(MONTHNAME(MONTH(NOW)), MonthAbbv_Length)
  IF LEN(MonthStr) > MonthAbbv_Length THEN MonthStr = LEFT(MONTHNAME(MONTH(NOW), 1), MonthAbbv_Length)
 END IF
END IF
IF MonthAbbv_RemovePeriod AND RIGHT(MonthStr, 1) = "." THEN MonthStr = LEFT(MonthStr, LEN(MonthStr)-1)


	IF LEN(DAY(NOW)) = 1 AND SingleDigitDayStr <> "" THEN
		DayStr = SingleDigitDayStr & DAY(NOW)
	ELSE
		DayStr = DAY(NOW)
	END IF

    IF LEFT(DateValue("31 12 2003"), 2) = "12" THEN 'use DAY/MONTH OR MONTH/DAY
        MonthFirst = 1
        IF LEN(TodaysIndicator) > 0 THEN
            TodaysStr = LEFT(TodaysIndicator, 1) & MonthStr & " " & DayStr
            IF LEN(TodaysIndicator) > 1 THEN TodaysStr = TodaysStr & MID(TodaysIndicator, 2, 1)
            TodaysStr = TodaysStr & " "
        ELSE
            TodaysStr = MonthStr & " " & DayStr & " "
        END IF
    ELSE
        IF LEN(TodaysIndicator) > 0 THEN
            TodaysStr = LEFT(TodaysIndicator, 1) & DayStr & " " & MonthStr
            IF LEN(TodaysIndicator) > 1 THEN TodaysStr = TodaysStr & MID(TodaysIndicator, 2, 1)
            TodaysStr = TodaysStr & " "
        ELSE
            TodaysStr = DayStr & " " & MonthStr & " "
        END IF
    END IF

IF EventCount = 0 AND TodaysText <> "0" THEN AllText = AllText & TodaysStr & Hyphen & " " & TodaysText & VBCRLF : todayisdone = 1



'----Start with the event text
FOR x = 1 TO EventCount
 EventDate = DATESERIAL(EventYear(x), EventMonth(x), EventDay(x))
 PrevEventDate = DATESERIAL(EventYear(x-1), EventMonth(x-1), EventDay(x-1))
 IF x = 1 THEN PrevEventDate = NOW

	IF LEN(EventDay(x)) = 1 AND SingleDigitDayStr <> "" THEN
		EventDayStr = SingleDigitDayStr & EventDay(x)
	ELSE
		EventDayStr = EventDay(x)
	END IF

 IF MonthAbbv_Case = 2 THEN
  EventMonthStr = UCASE(MONTHNAME(EventMonth(x), 1))
  IF MonthAbbv_Length <> 0 THEN
   IF LEN(EventMonthStr) < MonthAbbv_Length THEN EventMonthStr = UCASE(LEFT(MONTHNAME(EventMonth(x)), MonthAbbv_Length))
   IF LEN(EventMonthStr) > MonthAbbv_Length THEN EventMonthStr = UCASE(LEFT(MONTHNAME(EventMonth(x), 1), MonthAbbv_Length))
  END IF
 ELSEIF MonthAbbv_Case = 1 THEN
  EventMonthStr = UCASE(LEFT(MONTHNAME(EventMonth(x), 1), 1)) & MID(MONTHNAME(EventMonth(x), 1), 2, LEN(MONTHNAME(EventMonth(x), 1))-1)
  IF MonthAbbv_Length <> 0 THEN
   IF LEN(EventMonthStr) < MonthAbbv_Length THEN EventMonthStr = UCASE(LEFT(MONTHNAME(EventMonth(x)), 1)) & MID(MONTHNAME(EventMonth(x)), 2, MonthAbbv_Length-1)
   IF LEN(EventMonthStr) > MonthAbbv_Length THEN EventMonthStr = UCASE(LEFT(MONTHNAME(EventMonth(x), 1), 1)) & MID(MONTHNAME(EventMonth(x), 1), 2, MonthAbbv_Length-1)
  END IF
 ELSE
  EventMonthStr = MONTHNAME(EventMonth(x), 1)
  IF MonthAbbv_Length <> 0 THEN
   IF LEN(EventMonthStr) < MonthAbbv_Length THEN EventMonthStr = LEFT(MONTHNAME(EventMonth(x)), MonthAbbv_Length)
   IF LEN(EventMonthStr) > MonthAbbv_Length THEN EventMonthStr = LEFT(MONTHNAME(EventMonth(x), 1), MonthAbbv_Length)
  END IF
 END IF
 IF MonthAbbv_RemovePeriod THEN
  IF RIGHT(EventMonthStr, 1) = "." THEN EventMonthStr = LEFT(EventMonthStr, LEN(EventMonthStr)-1)
 END IF


 IF EventYear(x) > YEAR(NOW) THEN PasteAfter = 1
 IF EventYear(x) < YEAR(NOW) THEN PasteBefore = 1

 IF EventYear(x) <> YEAR(NOW) THEN
    TextString = " " & Hyphen & " " & EventText(x) & VBCRLF
    IF (EventMonth(x) = EventMonth(x-1) AND EventDay(x) = EventDay(x-1)) OR (EventMonth(x) = MONTH(NOW) AND EventDay(x) = DAY(NOW)) THEN 'indent text
		CutText = VBTAB & TextString
    ELSE    'don't indent text
		IF MonthFirst THEN CutText = EventMonthStr & " " & EventDayStr & TextString
		IF MonthFirst = 0 THEN CutText = EventDayStr & " " & EventMonthStr & TextString
    END IF
    AllCutText = AllCutText & CutText
 END IF

 IF EventYear(x) = YEAR(NOW) THEN
    IF PrevEventDate <= NOW AND NOW <= EventDate + 1 THEN
     IF TodaysText <> "0" AND todayisdone = 0 THEN AllText = AllText & TodaysStr & Hyphen & " " & TodaysText & VBCRLF : todayisdone = 1
    END IF
    TextString = " " & Hyphen & " " & EventText(x) & VBCRLF
    IF (EventMonth(x) = EventMonth(x-1) AND EventDay(x) = EventDay(x-1)) OR (EventMonth(x) = MONTH(NOW) AND EventDay(x) = DAY(NOW)) THEN 'indent text
		ExtractedText = VBTAB & TextString
    ELSE    'don't indent text
		IF MonthFirst THEN ExtractedText = EventMonthStr & " " & EventDayStr & TextString
		IF MonthFirst = 0 THEN ExtractedText = EventDayStr & " " & EventMonthStr & TextString
    END IF
    AllText = AllText & ExtractedText
 END IF
NEXT

IF TodaysText <> "0" AND todayisdone = 0 THEN AllText = AllText & TodaysStr & Hyphen & " " & TodaysText & VBCRLF

IF PasteBefore THEN ExtractedText = AllCutText & AllText
IF PasteAfter THEN ExtractedText = AllText & AllCutText
IF PasteBefore = 0 AND PasteAfter = 0 THEN ExtractedText = AllText

EventCount=0 'reset the event count
END FUNCTION





'========================================================================================================
'========================================================================================================
'========================================================================================================
PRIVATE FUNCTION EnterReminder(PositionType)

	IF PositionType = "ActualDay" THEN	'the day number is already known
		IF 0 < CP AND CP < 31 THEN
		    'make a new date with the day added to the monthshifted month/year
		    TheDate = DATESERIAL(TheYear, TheMonth, CP)
			ThisDay = DAY(TheDate)
			ThisMonth = MONTH(TheDate)
			ThisYear = YEAR(TheDate)
		END IF
	ELSEIF PositionType = "GridPosition" THEN	'figure out the day number from the grid position
		IF 0 < CP AND CP < 43 THEN     'a day was clicked on
			FirstDayOfMonth = DATEPART("w", DATESERIAL(TheYear, TheMonth, "1"), 0)
			'msgbox "TheDate: " & TheDate & vbcrlf & "TheMonth: " & TheMonth & vbcrlf & "TheYear: " & TheYear & vbcrlf & "FDoM:" & FirstDayOfMonth
    		TheDate = DATESERIAL(TheYear, TheMonth, CP - FirstDayOfMonth + 1)	'correct for monthshift
			ThisDay = DAY(TheDate)
			ThisMonth = MONTH(TheDate)
			ThisYear = YEAR(TheDate)
		END IF
		
		IF 42 < CP AND CP < 50 THEN SquareClickedOn = WEEKDAYNAME(CP-42, 0, 0)
		IF CP = 50 THEN SquareClickedOn = FSO.OpenTextFile(CalendarMonthFile, 1).Readline
	END IF

'---open the events file and find the Reminders section
 ReadDataFile "Reminders", 365, 0, ThisDay, ThisMonth, ThisYear
 SET DataFileStream = FSO.OpenTextFile(EventsFile, 1)
 FOR x = 1 TO LineNumber
  EventLine = TRIM(DataFileStream.ReadLine)
  FirstPart = FirstPart & EventLine & VBCRLF
 NEXT
 DO WHILE DataFileStream.AtEndOfStream <> TRUE
  EventLine = TRIM(DataFileStream.ReadLine)
  SecondPart = SecondPart & EventLine & VBCRLF
 LOOP
 DataFileStream.Close

 EventCount = 0
 ReadDataFile "Holidays", 0, 0, ThisDay, ThisMonth, ThisYear
 ReadDataFile "Birthdays", 0, 0, ThisDay, ThisMonth, ThisYear
 ReadDataFile "Reminders", 0, 0, ThisDay, ThisMonth, ThisYear
 SortAllEvents

 FOR x = 1 TO EventCount    'create event list to display in message box
  EventList = EventList & "  " & x & " " & Hyphen & " " & EventText(x) & VBCRLF
 NEXT

IF SquareClickedOn <> "" THEN
 wscript.echo "You clicked on " & SquareClickedOn & ", but this version of SimpleEvents does not let you edit weekday events."
END IF

IF EventList <> "" THEN
  Reminder = InputBox("Current Events:" & CHR(13) & EventList & CHR(13)&CHR(13)&CHR(13)&CHR(13)&CHR(13) & "Type " & CHR(34) & DeleteCommand & " #" & CHR(34) & " or " & CHR(34) & DeleteCommand & " ALL" & CHR(34) & " to delete events," & CHR(13) & "Or enter another event and click OK:", MONTHNAME(ThisMonth) & " " & ThisDay & ", " & ThisYear)
ELSEIF ThisDay <> "" THEN
  Reminder = InputBox(CHR(13)&CHR(13)&CHR(13)&CHR(13)&CHR(13) & "Enter an event and click OK:", MONTHNAME(ThisMonth) & " " & ThisDay & ", " & ThisYear)
END IF

IF Reminder <> "" THEN
  IF MID(Reminder, 1, LEN(DeleteCommand)) = DeleteCommand THEN  'delete an event
    IF MID(Reminder, LEN(DeleteCommand)+2, 3) = "ALL" THEN
      'the line numbers don't match after deleting the first event!!!
      SET DataFileStream = FSO.OpenTextFile(EventsFile, 1)
        DO WHILE DataFileStream.AtEndOfStream <> TRUE
         EventLine = TRIM(DataFileStream.ReadLine)
         LineCount = LineCount + 1
         FOR x = 1 TO EventCount
          IF EventLineNumber(x) = LineCount THEN IgnoreThisLine = 1
         NEXT
         IF IgnoreThisLine = 0 THEN EditedEventsFile = EditedEventsFile & EventLine & VBCRLF
         'If IgnoreThisLine = 1 Then wscript.echo "ignore: " & EventLine
         IgnoreThisLine = 0
        LOOP
        DataFileStream.Close
        FSO.CreateTextFile(EventsFile, 1).WRITE(EditedEventsFile)
    ELSE
      SET DataFileStream = FSO.OpenTextFile(EventsFile, 1)
      EventNumberToDelete = CINT(MID(Reminder, LEN(DeleteCommand)+2, 2))
        FirstPart = "" : SecondPart = ""
        FOR x = 1 TO EventLineNumber(EventNumberToDelete) - 1
         EventLine = TRIM(DataFileStream.ReadLine)
         FirstPart = FirstPart & EventLine & VBCRLF
        NEXT
        DataFileStream.ReadLine  'skips this line cuz it's getting deleted
        DO WHILE DataFileStream.AtEndOfStream <> TRUE
         EventLine = TRIM(DataFileStream.ReadLine)
         SecondPart = SecondPart & EventLine & VBCRLF
        LOOP
        FSO.CreateTextFile(EventsFile, 1).WRITE(FirstPart & SecondPart)
     END IF
  ELSE
   FSO.CreateTextFile(EventsFile, 1).WRITE(FirstPart & ThisDay & "/" & ThisMonth & "/" & ThisYear & "=" & CHR(34) & Reminder & CHR(34) & VBCRLF & SecondPart)
  END IF


 EventCount = 0
 RefreshCalendar

 SET File = FSO.GetFile(EventsFile)
 File.attributes = File.attributes - 32     'removes the file's archive flag so SimpleCalendar can detect when a new Event.dat file is being used.
END IF
END FUNCTION


'========================================================================================================
'========================================================================================================
'========================================================================================================