'=======================================================================
' scroll.vbs		v0.9					- NeM
'=======================================================================

' Simple script to scroll a line of text either given as a parameter
' or read from a file.

' NOTE: For this script to be really useful, you will probably have 
'       to set the update time for the meter to 1 second. You can
'       do this by opening your config file in notepad and doing the
'       following:
'
'       In the TActiveScriptCollector section for the ActiveScript 
'       meter, change the line that reads:
'
' 	  	Interval=x
'
'	  to:
'
'		IntervalSeconds=1

' scrollText scrolls the text entered as the 'myText' parameter.
' 
' scrollFileText scrolls the text found in the file with the name 
' passed as the 'fileName' parameter, usually in your Samurize
' root directory.

' KNOWN BUGS:
' ===========
'
' - currently the script only seems to update every 5 seconds no matter
'   how frequent the script is set to run. Maybe it's just me...
'
' Please report bugs to nem@samurize.com

'=======================================================================

'=======================================================================
' USER SETTINGS:
' ==============

' text to indicate the end of text in the scroller
DIVIDER = " --- "

'=======================================================================

Function scrollText(myText, scrollLength)
	temp = myText & DIVIDER
	startPos = (Timer) Mod Len(temp) + 1
	scrollText = mid(temp, startPos, scrollLength)
	scrollText = scrollText & mid(temp, 1, scrollLength - Len(scrollText))
End Function

Function scrollFileText(fileName, scrollLength)
	temp = readFile(fileName) & DIVIDER
	startPos = (Timer) Mod Len(temp) + 1
	scrollFileText = mid(temp, startPos, scrollLength)
	scrollFileText = scrollFileText & mid(temp, 1, scrollLength - Len(scrollFileText))
End Function

Private Function readFile(fileName)
	Dim contents
	Set fs = CreateObject ("Scripting.FileSystemObject")
      If (fs.FileExists(fileName)) Then
		Set filePath = fs.GetFile(fileName)
		Set File = filePath.OpenAsTextStream (1, -2)
		contents = file.readall
		File.Close
		' return file contents
		readFile = contents
	Else 
		readFile = "File '" & filename & "' does not exist"
      End If
End Function