'Extended Drive Attributes VBScript
'Version 1.5
'Created 4th June 2002
'Last Modified 19th March 2003
'Copyright 2003, Rowan Gillson
'Not redistributable without express permission from author.
'Suitable for Windows 2000/Windows XP only.
'
'
'comments to r_gillson@hotmail.com
'

On Error Resume Next

Dim oFileSys, Drive, sDriveType, ComputerName, DriveIndex

'----------------------------------------------
'WMI Class Enumerator
'----------------------------------------------
Private Sub GetWMI(ComputerName, WMIArray, WMIQuery, WMIExtension)

Set WMIClass = GetObject("winmgmts:" _
    & "{impersonationLevel=impersonate}!\\" & ComputerName & "\root\cimv2")
Set WMIArray = WMIClass.ExecQuery(WMIQuery & WMIExtension)

End Sub

'----------------------------------------------

'----------------------------------------------
'Displays fixed disk model
Function DriveName(ComputerName, DriveIndex)

Call GetWMI(ComputerName, DiskInfoSet, "Select * from Win32_DiskDrive where Index = ", DriveIndex)

For Each objDiskInfo in DiskInfoSet
	DriveName = objDiskInfo.Model
Next

End Function

'----------------------------------------------
'Displays SCSI Bus ID
Function SCSIBusID(ComputerName, DriveIndex)

Call GetWMI(ComputerName, DiskInfoSet, "Select * from Win32_DiskDrive where Index = ", DriveIndex)

For Each objDiskInfo in DiskInfoSet
	SCSIBusID = objDiskInfo.SCSIBus
Next

End Function

'----------------------------------------------
'Displays SCSI Logical Unit Number (LUN)
Function SCSILunID(ComputerName, DriveIndex)

Call GetWMI(ComputerName, DiskInfoSet, "Select * from Win32_DiskDrive where Index = ", DriveIndex)

For Each objDiskInfo in DiskInfoSet
	SCSILunID = objDiskInfo.SCSILogicalUnit
Next

End Function

'----------------------------------------------
'Displays SCSI Port Number
Function SCSIPortID(ComputerName, DriveIndex)

Call GetWMI(ComputerName, DiskInfoSet, "Select * from Win32_DiskDrive where Index = ", DriveIndex)

For Each objDiskInfo in DiskInfoSet
	SCSIPortID = objDiskInfo.SCSILogicalUnit
Next

End Function

'----------------------------------------------
'Displays SCSI Target Id
Function SCSITargetID(ComputerName, DriveIndex)

Call GetWMI(ComputerName, DiskInfoSet, "Select * from Win32_DiskDrive where Index = ", DriveIndex)

For each objDiskInfo in DiskInfoSet
	SCSITargetID = objDiskInfo.SCSITargetId
Next

End Function

'----------------------------------------------


'----------------------------------------------
'Displays individual drive volume name
Function VolumeName(DriveLetter)

Set oFileSys = CreateObject("Scripting.FileSystemObject")
Set Drive = oFileSys.GetDrive(Driveletter)

If Drive.IsReady = True Then
	VolumeName = Drive.VolumeName
Else
	VolumeName = "Not Ready"
End If

End Function

'----------------------------------------------
'Displays individual volume type
Function DriveType(DriveLetter)

Set oFileSys = CreateObject("Scripting.FileSystemObject")
Set Drive = oFileSys.GetDrive(Driveletter)

Select Case Drive.DriveType
	Case 0: sDriveType = "Unknown"
	Case 1: sDriveType = "Removable"
	Case 2: sDriveType = "Fixed"
	Case 3: sDriveType = "Network"
	Case 4: sDriveType = "CD-ROM"
	Case 5: sDriveType = "RAM Disk"
End Select
	DriveType = sDriveType

End Function

'----------------------------------------------
'Displays individual partition filesystem type
Function FileSysType(DriveLetter)

Set oFileSys = CreateObject("Scripting.FileSystemObject")
Set Drive = oFileSys.GetDrive(Driveletter)

If Drive.IsReady = True Then
	FileSysType = Drive.FileSystem
Else
	FileSysType = "Not Ready"
End If

End Function

