' #########################################################################################
' ----------------------- HOTMAIL CHECKER v0.3 by tomchuk ---------------------------------
' #########################################################################################

' Email me at projects@tomchuk.com if you have any problems or questions

' A little script to grab some info about your Hotmail account.

' This will only fully work with Samurize 0.85b and above.

' #########################################################################################
' ----------------------- UPDATES ---------------------------------------------------------
' #########################################################################################

' Finally fixed writefile so that it doesn't puke when it finds Unicode characters

' Added error checking for GetNumNewMail and GetNumTotalMail to output 0 instead
'   of "" for number of messages if you have no new or no total messages in your
'   inbox.

' Revised the regular expression for WriteFile so that it works with all languages

' Commented the important bits of the functions

' Added ability to specify folder to check

' Added tons of comments and instructions for tweaking the script

' #########################################################################################
' ----------------------- Available Functions ---------------------------------------------
' #########################################################################################

' 1. GetNumNewMail - Get the total number of unread messages in your inbox

' 2. GetNumTotalMail - Get the total of read and unread messages in your inbox

' 3. GetNewSender - Will ask for a "LineNumber" paramater - this is the line number
'    of the new mail your want to get the sender for. Enter 1 for the newest sender,
'    2 for the second newest, etc.

' 4. GetNewSubject - Will ask for a "LineNumber" paramater - this is the line number
'    of the new mail your want to get the sendersubject for. Enter 1 for the newest 
'    subject, 2 for the second newest, etc.

' 5. GetAllNewSender - Creates a list of all the senders of new messages in your inbox
'    with line breaks in between each.

' 5. GetAllNewSubject - Creates a list of all the subjects of new messages in your inbox
'    with line breaks in between each.

' 6. WiterFile - connects to the hotmail website and grabs the contents of your inbox and
'    writes them to a file defined by Path, below.

' #########################################################################################
' ----------------------- SETUP INSTRUCTIONS ----------------------------------------------
' #########################################################################################

' 1. Open Internet Explorer and go to http://www.hotmail.msn.com/cgi-bin/HoTMaiL

' 2. If you're looking at your inbox, you're all set. If not got to 3.

' 3. You'll need to enter your hotmail username and password in the spaces provided
'    Make sure you also check "Sign me in automatically" before you press "Sign In".

' 4. In your samurize config, add the writefile meter and set it to the interval you'd
'    like to check for new mail. Go easy, hotmail is a big site, but hitting it every
'    5 minutes is far too often.

' 5. You must allow cookies for this to work.

' 6. If someone else logs into hotmail while logged in under your username, they
'    will have to log you out first, this will break this script's ability to access
'    your Hotmail account. To fix this, follow steps 1 - 3 again.

' #########################################################################################
' ----------------------- VARIABLES -------------------------------------------------------
' #########################################################################################

' This script will work fine if you don't change these, but you can if you want. A comment
' in VBS is an apostrophie, written ' If you want to comment out a line add an apostrophie
' to the beginning. If you want to uncomment a line remove the apostrophie. It's that simple.
' Make sure if you are using an international keyboard that you are enerting ' not ` or any
' or any other variation.

' HOTMAILURL VARIABLE INSTRUCTIONS
' HotmailURL is the address for Hotmail, stripped of any session variables or current
' maibox variables. Unless MS changes things, you shouldn't need to touch this.

HotmailURL = "http://hotmail.msn.com/cgi-bin/HoTMaiL"

' MAILBOXFOLDER VARIABLE INSTRUCTIONS
' MailboxFolder is the folder you want to check. Leave the apostrophies as they are
' to just check your inbox. You can change the mailbox you're checking by removing
' the apostrophie from the beginning of the line and adding one to the inbox line.
' If you've added Folders, go to them in IE and look for the line "?curmbox=F????????"
' in the address bar and change F00000001 to F???????? in the line below. For instance,
' I have a folder stuff that is curmbox=F148891668, so I'd add the line:
' MailboxFolder = "?curmbox=F148891668"

MailboxFolder = "?curmbox=F000000001" ' your inbox
'MailboxFolder = "?curmbox=F000000002" ' your sent folder
'MailboxFolder = "?curmbox=F000000003" ' your drafts folder
'MailboxFolder = "?curmbox=F000000004" ' your trash can
'MailboxFolder = "?curmbox=F000000005" ' your junk mail

' PATH VARIABLE INSTRUCTIONS
' Path is where WriteFile will store the captured page and what it will be called.
' If left alone WriteFile will store the page in the same directory that config.exe
' is in when run from the config program and will store it in the Scripts directory
' when run from the Samurize client. If you'd like to set an absolute path so that
' you hotmail info is always stored in the same directory regardless of where the
' script is run from you can uncomment the following line and change it to where you
' want things stored. If you do this make sure to add and apostrophie to the original
' Path line. Also make sure that the directory exists or you'll get a "Path not found" error.
'Path = "C:\Program files\Samurize\Temp\hotmail.html" 'uncomment this line for an absolute path
Path = "hotmail.html" ' comment out this line if you uncomment the above line


' #########################################################################################
' ----------------------- FUNCTIONS - DON'T EDIT BELOW ------------------------------------
' #########################################################################################

Function GetNumNewMail ' Returns the number of unread messages in your inbox
	Set fso = CreateObject ("Scripting.FileSystemObject")
	set f = fso.OpenTextFile(Path, 1)
	While f.AtEndOfStream <> True 
		SearchString = f.readline
		If InStr(1, SearchString, "NEWMAIL", 1) > 0 Then
			MailCount = MailCount + 1 ' If "NEWMAIL" is found on this line increment the
		End If						  ' MailCount counter
	Wend
	f.close
	If MailCount > 0 Then ' Return Mailcount if there are messages, return 0 if not
		GetNumNewMail = MailCount
	Else
		GetNumNewMail = 0
	End If
End Function

Function GetNumTotalMail
	Set fso = CreateObject ("Scripting.FileSystemObject")
	set f = fso.OpenTextFile(Path, 1)
	While f.AtEndOfStream <> True 
		SearchString = f.readline
		If InStr(1, SearchString, "NEWMAIL", 1) > 0 or InStr(1, SearchString, "OLDMAIL", 1) > 0 Then
			MailCount = MailCount + 1 ' Increment the MailCount counter for every message in inbox
		End If
	Wend
	f.close
	If MailCount > 0 Then ' Return Mailcount if there are messages, return 0 if not
		GetNumTotalMail = MailCount
	Else
		GetNumTotalMail = 0
	End If
End Function

Function GetNewSender(LineNumber)
Set fso = CreateObject ("Scripting.FileSystemObject")
	set f = fso.OpenTextFile(Path, 1)
	Dim Senders
	Dim count
	While f.AtEndOfStream <> True 
		SearchString = f.readline
		If InStr(1, SearchString, "NEWMAIL", 1) > 0 Then
			count = count + 1 ' Grab each line and add the SENDERSTARTn and SENDERENDn markers to make life easy later on
			Senders = Senders & " SENDERSTART" & count & " " & RegExpPattern_(SearchString, "len=(.*?)>(.*?)</a>&nbsp;</td><td>", 1) & " SENDEREND" & count
		End If
	Wend
	f.close ' Look for SENDERSTART(LineNumber) to identify the sender we want
	GetNewSender = RegExpPattern_(Senders, "SENDERSTART" & LineNumber & " (.*?) " & "SENDEREND" & LineNumber, 0)
End Function

Function GetNewSubject(LineNumber)
	Set fso = CreateObject ("Scripting.FileSystemObject")
	set f = fso.OpenTextFile(Path, 1)
	Dim Subjects
	Dim count
	While f.AtEndOfStream <> True 
		SearchString = f.readline
		If InStr(1, SearchString, "NEWMAIL", 1) > 0 Then
			count = count + 1 ' Grab each line and add the SUBJECTSTARTn and SUBJECTENDn markers to make life easy later on
			Subjects = Subjects & " SUBJECTSTART" & count & " " & RegExpPattern_(SearchString, "len=(.*?)>(.*?)</a>&nbsp;</td><td>(.*?)&nbsp;</td><td>", 2) & " SUBJECTEND" & count
		End If
	Wend
	f.close ' Look for SUBJECTSTART(LineNumber) to identify the subject we want
	GetNewSubject = RegExpPattern_(Subjects, "SUBJECTSTART" & LineNumber & " (.*?) " & "SUBJECTEND" & LineNumber, 0)
End Function

Function GetAllNewSender
	Set fso = CreateObject ("Scripting.FileSystemObject")
	set f = fso.OpenTextFile(Path, 1)
	Dim Senders
	Dim count
	While f.AtEndOfStream <> True 
		SearchString = f.readline
		If InStr(1, SearchString, "NEWMAIL", 1) > 0 Then ' Look for NEWMAIL marker and add each sender to the end of Senders with a Sam line break
			Senders = Senders & RegExpPattern_(SearchString, "len=(.*?)>(.*?)</a>&nbsp;</td><td>", 1) & "%b"
		End If
	Wend
	f.close
	GetAllNewSender = Senders
End Function

Function GetAllNewSubject
	Set fso = CreateObject ("Scripting.FileSystemObject")
	set f = fso.OpenTextFile(Path, 1)
	Dim Subjects
	Dim count
	While f.AtEndOfStream <> True 
		SearchString = f.readline
		If InStr(1, SearchString, "NEWMAIL", 1) > 0 Then ' Look for NEWMAIL marker and add each subject to the end of Subjects with a Sam line break
			Subjects = Subjects &  RegExpPattern_(SearchString, "len=(.*?)>(.*?)</a>&nbsp;</td><td>(.*?)&nbsp;</td><td>", 2) & "%b"
		End If
	Wend
	f.close
	GetAllNewSubject = Subjects
End Function

Function WriteFile
	Randomize
		GetURL = HotmailURL & MailboxFolder & "&random=" & Rnd ' Add a random variable to the URL to make sure we're getting a fresh page each time
	Dim Http, I, S, ToWrite
	Set Http = CreateObject("Microsoft.XMLhttp")
	Http.Open "GET", GetURL, False
	Http.Send
	ReturnedData = Http.ResponseText
	For I = 1 To Len(ReturnedData)
	ToWrite = ToWrite & Chr(Asc(Mid(ReturnedData, I, 1))) 'Make sure we're working with ASCI characters not Unicode - thanks yuit
	Next
	ToWrite = Replace(ToWrite, chr(10), "") 'Get rid of newline characters, then cut out the bits we don't need
	ToWrite = RegExpPattern_(ToWrite, "</font></a>&nbsp;</nobr></td></tr>(.*?)</td></tr></table></td></tr></form></table></td></tr></table></td></tr></table>", 0)
	ToWrite = Replace(ToWrite, chr(34), "") ' Get rid of quotation marks, as they screw with the regexp's
	ToWrite = Replace(ToWrite, "</td></tr>", "</td></tr>" & chr(10)) ' Put each message on its own line
	ToWrite = Replace(ToWrite, "<tr bgcolor=#FFF7E5>", "NEWMAIL  ") ' table rows with background #FFF7E5 indicate new mail - replace with the NEWMAIL marker
	ToWrite = Replace(ToWrite, "<tr bgcolor=#FFFFFF>", "OLDMAIL  ") ' table rows with background #FFFFFF indicate old mail - replace with the OLDMAIL marker
	Set Http = Nothing
	Set fs=CreateObject("Scripting.FileSystemObject")
	Set f=fs.CreateTextFile(Path,true)
	f.write(ToWrite)
	f.close
	Set f=nothing
	Set fs=nothing
	WriteFile = "TempFile Written"
End Function

Function RegExpPattern_(Input, patrn, MatchNum)
	Set regEx = New RegExp 
	regEx.Global = True
	regEx.IgnoreCase = True
	regEx.Pattern = patrn
	Set Matches = regEx.Execute(Input) 
	For Each Match in Matches 
		result = trim(Match.SubMatches(MatchNum))
	Next 
	RegExpPattern_ = result
End Function

' Hotmail and MSN are copyright Microsoft Corporation