' **************************************************************************
' AustraliaTV.vbs v2.2
' **************************************************************************

' Retreives free-to-air, Optus and Foxtel TV listings for Australia from
' www.ebroadcast.com.au
'
' This script is written for Samurize 0.85b. I cannot guarantee that it will
' work with any earlier versions of Samurize.

' The author takes no responsibility for the usage of this script. Use it
' at your own discretion!

'                                                             - NeM

' =====================
' INSTRUCTIONS FOR USE:
' =====================

' INSTALLATION:
' -------------

' 1) Unzip/copy AustraliaTV.vbs to your Samurize/Scripts folder
'
' 2) Configure your script for your region - see below
'
' 3) Alter the User Preferences below as you wish
' 
' USAGE:
' ------

' Use a meter with the getListing function to update your TV listings. This
' function will update the listings as necessary, so you can set its update
' interval quite low without wasting bandwidth.
'
' To obtain the listing for a particular channel, add a meter with either
' the whatsOnNow or whatsOnNext function, corresponding to what is currently
' showing on TV and what is coming up next. Enter the name of the channel 
' you want listings for as the channel parameter. NOTE: Channel names are 
' CASE-SENSITIVE ie. for listings for ABC, you MUST enter ABC as the channel 
' parameter, not abc or aBC etc. Check the valid channel names in the 
' channelnames.txt file included with this zip file.

' =================
' Changes in v2.21: -- by NeM (nem@samurize.com)
' =================
' - fixed &%$&^ "ePICK" bug!

' ================
' Changes in v2.2: -- by NeM (nem@samurize.com)
' ================
'
' - page format seemed to have changed - this is now fixed.
' - No I didn't forget to add a CURRENT_SHOW_TIMES variable - I assumed
'   people would always want to see what is currently on :P
'
' ================
' Changes in v2.1: -- by Blackout (petergilchrist@thebunker.com.au)
' ================
'
' - now able to see whats in the next Timeslot instead of 'Unavailable'
' - fixed a bug where from 12:00pm - 12:59pm it would display the programs playing in the last program box
' - updated status messages in getListing(), now allows 2 files
' - added 'CURRENT_SHOW_TIMES = True' to the variables section the script. i think NeM forgot it :)

' ================
' Changes in v2.0:
' ================
' 
' - 100% REWRITTEN FROM SCRATCH
' - uses different site to obtain TV listings
' - added TV listings for Optus and Foxtel
' - greater customizability
' - easier to configure
' - lower traffic usage

' Thanks to Alderaic for his trimHTML function

' **************************************************************************
' USER OPTIONS - edit these to suit your region/preferences
' **************************************************************************
'
' =======
' REGION:
' =======
'
' *IMPORTANT* Remove the ' character from the line that contains your region
' below. IF YOU DO NOT DO THIS, THE SCRIPT WILL NOT WORK!

' STATE = "Adelaide"
' STATE = "SAReg"			' SA Regional
' STATE = "Brisbane"
' STATE = "QLDReg"			' QLD Regional
' STATE = "Canberra"
' STATE = "Darwin"
' STATE = "NTReg"			' NT Regional
' STATE = "Hobart"
' STATE = "TASReg"			' TAS Regional
' STATE = "Melbourne"
' STATE = "VICReg"			' VIC Regional
' STATE = "Perth"
' STATE = "WAReg"			' WA Regional
 STATE = "Sydney"
' STATE = "NSWReg"			 NSW Regional


' ================
' USER PREFERENCES
' ================

SHOW_TIMES = True		' set to False if you don't want the start 
CURRENT_SHOW_TIMES = True	' time For the current show displayed


' Channel options
' ---------------
' only alter these if you want to minimise the bandwidth requirements even 
' further

OPTUS_OPTION = 0		' set to 0 if you don't want Optus listings
FOXTEL_OPTION = 1		' set to 0 if you don't want Foxtel listings
CONVERT_CASE = True		' set to false to disable converting of all UPPERCASE to Lowercase

' **************************************************************************

TV_URL = "http://www.ebroadcast.com.au/cgi-bin/TV/"
TMP_FILE = "ausTV_current.tmp"
TMP2_FILE = "ausTV_next.tmp"

EPICK = "<table cellpadding=""0"" cellspacing=""0"" border=""0"" width=""100%"" bgcolor=""#EDEDED""><tr><td width=""30""><img src=""http://www.ebroadcast.com.au/tv/feature/tick.gif"" alt=""Top Watch!"" width=""30"" height=""29"" hspace=""0"" vspace=""0"" border=""0""></td><td><font face=""verdana,arial,helvetica"" size=""1"" color=""#2D2D2D""><b>ePICK</b></font></td></tr></table>"

Function whatsOnNext (channel)
	currentTime = getTime

	htmlResult = readFile(TMP_FILE)

	checkString = ">" & channel & "</font></a>"
	channelPos = InStr(htmlResult, checkString)

	If channelPos > 0 Then
		' trim the text
		htmlResult = mid(htmlResult, channelPos)
		
		' chop off everything after </TR>
		trPos = InStr(htmlResult, "</TR>")
		htmlResult = mid(htmlResult, 1, trPos)
		backuphtml = htmlResult ' save for getting the show title
		
		Dim timeList(24)
		i = 0
		
		Do While InStr(htmlResult, "<TD ") > 0
		
			tdPos = InStr(htmlResult, "<TD ")+1
			htmlResult = mid(htmlResult, tdPos)
			
			
			sizePos = InStr(htmlResult, "size=1>") + 7
			mPos = InStr(htmlResult, "m:")
			timeList(i) = mid(htmlResult, sizePos, mPos-sizePos+2)
			
			i = i + 1

			temphtml = htmlResult

			Do While 0 < 1
			
				' check for another show in one cell
				brPos = InStr(temphtml, "<BR>") + 4
				fontPos = InStr(temphtml, "</font>")
				
				If (fontPos - brPos) < 2 Then
					Exit Do
				End If

				temphtml = mid(temphtml, brPos, fontPos - brPos + 7)
			
				check = InStr(temphtml, ":")
			
				If check > 0 Then

					' another show found
					timeList(i) = mid(temphtml, 1, check)
					i = i + 1

				End If
			Loop	
		
		Loop
		
		j = 0
		
		For Each timeSlot In timeList
			
			' stop if no more TV shows found
			If Len(timeSlot) < 2 Then
				Exit For
			End If
		
			If timeGreaterThan(timeSlot,currentTime) = False Then
				j = j + 1
			Else
				Exit For
			End If

		Next
		
		backuphtml = mid(backuphtml, InStr(backuphtml, timeSlot))
		endTitle = InStr(backuphtml, "</") - 1
		
		whatsOnNext = trimHTML(mid(backuphtml, 1, endTitle))
		
	Else
		whatsOnNext = "Unavailable"

	End If
	
	' check if next is unknown
	If whatsOnNext = ">" & channel Then
		whatsOnNext = whatsOnNext2(channel)
		If whatsOnNext = ">" & channel Then
			whatsOnNext = "Unknown"
		End If
	End If
	
	If CONVERT_CASE = True Then
		whatsOnNext = PCase(whatsOnNext)
	End If

	' more ePICK crap...
	whatsOnNext = replace(whatsOnNext, vbLf, "")


End Function

Function whatsOnNow (channel)
	currentTime = getTime
	
	htmlResult = readFile(TMP_FILE)

	checkString = ">" & channel & "</font></a>"
	channelPos = InStr(htmlResult, checkString)

	If channelPos > 0 Then
		' trim the text
		htmlResult = mid(htmlResult, channelPos)
		
		' chop off everything after </TR>
		trPos = InStr(htmlResult, "</TR>")
		htmlResult = mid(htmlResult, 1, trPos)
		backuphtml = htmlResult ' save for getting the show title
		
		Dim timeList(24)
		i = 0
		
		Do While InStr(htmlResult, "<TD ") > 0
		
			tdPos = InStr(htmlResult, "<TD ")+1
			htmlResult = mid(htmlResult, tdPos)
			
			
			sizePos = InStr(htmlResult, "size=1>") + 7
			mPos = InStr(htmlResult, "m:")
			timeList(i) = mid(htmlResult, sizePos, mPos-sizePos+2)
			
			i = i + 1

			temphtml = htmlResult

			Do While 0 < 1
			
				' check for another show in one cell
				brPos = InStr(temphtml, "<BR>") + 4
				fontPos = InStr(temphtml, "</font>")
				
				If (fontPos - brPos) < 2 Then
					Exit Do
				End If

				temphtml = mid(temphtml, brPos, fontPos - brPos + 7)
			
				check = InStr(temphtml, ":")
			
				If check > 0 Then

					' another show found
					timeList(i) = mid(temphtml, 1, check)
					i = i + 1

				End If
			Loop	
		
		Loop
		
		j = 0
		
		oldSlot = "none"
		
		For Each timeSlot In timeList
			
			' stop if no more TV shows found
			If Len(timeSlot) < 2 Then
				Exit For
			End If
		
			If timeGreaterThan(timeSlot,currentTime) = False Then
				j = j + 1
			Else
				Exit For
			End If

			oldSlot = timeSlot
		Next
		
		If oldSlot = "none" Then
			whatsOnNow = "Unknown"
			Exit Function
		End If
		
		backuphtml = mid(backuphtml, InStr(backuphtml, oldSlot))
		endTitle = InStr(backuphtml, "</") - 1
		
		whatsOnNow = trimHTML(mid(backuphtml, 1, endTitle))
		
		If CURRENT_SHOW_TIMES = False Then
			' chop off the time
			whatsOnNow  = mid(whatsOnNow, InStr(backuphtml, ":") + 2, Len(whatsOnNow))
		End If
		
		If CONVERT_CASE = True Then
			whatsOnNow = PCase(whatsOnNow)
		End If

	else
		whatsOnNow = "Unavailable"

	end if

	' more ePICK crap...
	whatsOnNow = replace(whatsOnNow, vbLf, "")



End Function



Function getListing ()

	dim fs,f,htmlResult
	
	'account for LateNight programs being displayed are from yesterdays date
	If timeOfDay = "LateNight" Then
		siteURL = TV_URL & "grid?date=" & getYesterdaysDate & "&TVperiod=" & timeOfDay & "&state=" & STATE & "&fta=1&fox=" & FOXTEL_OPTION & "&opt=" & OPTUS_OPTION
	Else
		siteURL = TV_URL & "grid?date=" & getDate & "&TVperiod=" & timeOfDay & "&state=" & STATE & "&fta=1&fox=" & FOXTEL_OPTION & "&opt=" & OPTUS_OPTION
	End If
	
	' check to see if update necessary
	oldHTML = readFile(TMP_FILE)
	checkString = getDate & " > Timeslot:  " & timeOfDay
	checkOldListing = InStr(oldHTML, checkString)
	
	If checkOldListing > 0 Then
		getListing = "Current Timeslot: No update necessary"
	Else
		' account for LateNight oddity
		If timeOfDay = LateNight Then 
			If InStr(oldHTML, "> " & yesterday) > 0 Then
				getListing = "No update necessary"
				Exit Function
			End If
			
		End If
	
	
		htmlResult = GetHTMLValue(siteURL)

		' remove epick crap
		htmlResult = replace(htmlResult, EPICK, "")

		checkFile = InStr(htmlResult, STATE)
	
		If checkFile > 0 Then
	
			' Minimise the temp file size and read/write times
			htmlResult = Mid(htmlResult, InStr(htmlResult, "<!-- end header-->"))
			htmlResult = Mid(htmlResult, 1, InStr(htmlResult, "<!-- start subfooter-->"))
	
	
			set fs=CreateObject("Scripting.FileSystemObject")
			Set f=fs.CreateTextFile(TMP_FILE,True)
			f.write(htmlResult)
			f.close
			set f=nothing
			set fs=nothing
	
			getListing = "Current Timeslot: Updated to " & TMP_FILE
	
		Else
			getListing = "Current Timeslot: Site error!"
		End If
	End If
	
	getListing = getListing & VbCrLf
	
	If timeOfDay = "LateNight" Then
		newtimeOfDay = "Morning"
	ElseIf timeOfDay = "Morning" Then
		newtimeOfDay = "Afternoon"
	ElseIf timeOfDay = "Afternoon" Then
		newtimeOfDay = "Night"
	Else
		newtimeOfDay = "LateNight"
	End If
	
	siteURL = TV_URL & "grid?date=" & getDate & "&TVperiod=" & newtimeOfDay & "&state=" & STATE & "&fta=1&fox=" & FOXTEL_OPTION & "&opt=" & OPTUS_OPTION
	
	' check to see if update necessary
	oldHTML = readFile(TMP2_FILE)
	checkString = getDate & " > Timeslot:  " & newtimeOfDay
	checkOldListing = InStr(oldHTML, checkString)
	
	If checkOldListing > 0 Then
		getListing = getListing & "Next Timeslot: No update necessary"
	Else
		' account for LateNight oddity
		If newtimeOfDay = LateNight Then 
			If InStr(oldHTML, "> " & yesterday) > 0 Then
				getListing = "No update necessary"
				Exit Function
			End If
			
		End If
	
	
		htmlResult = GetHTMLValue(siteURL)

		' remove epick crap
		htmlResult = replace(htmlResult, EPICK, "")
	
		checkFile = InStr(htmlResult, STATE)
	
		If checkFile > 0 Then
	
			' Minimise the temp file size and read/write times
			htmlResult = Mid(htmlResult, InStr(htmlResult, "<!-- end header-->"))
			htmlResult = Mid(htmlResult, 1, InStr(htmlResult, "<!-- start subfooter-->"))
	
	
			set fs=CreateObject("Scripting.FileSystemObject")
			Set f=fs.CreateTextFile(TMP2_FILE,True)
			f.write(htmlResult)
			f.close
			set f=nothing
			set fs=nothing
	
			getListing = getListing & "Next Timeslot: Updated to " & TMP2_FILE
	
		Else
			getListing = getListing & "Next Timeslot: Site error!"
		End If
	End If

'getListing = siteURL

End Function


' ***********************
' HELPER FUNCTIONS FOLLOW
' ***********************
Private Function PCase(strInput)
	iPosition = 1
	
	Do While InStr(iPosition, strInput, " ", 1) <> 0
		iSpace = InStr(iPosition, strInput, " ", 1)
		strOutput = strOutput & UCase(Mid(strInput, iPosition, 1))
		strOutput = strOutput & LCase(Mid(strInput, iPosition + 1, iSpace - iPosition))
		iPosition = iSpace + 1
	Loop
	
	strOutput = strOutput & UCase(Mid(strInput, iPosition, 1))
	strOutput = strOutput & LCase(Mid(strInput, iPosition + 1))
	
	PCase = strOutput
End Function

Private Function whatsOnNext2 (channel2)
	currentTime = getTime
	
	htmlResult = readFile(TMP2_FILE)

	checkString = ">" & channel2 & "</font></a>"
	channelPos = InStr(htmlResult, checkString)

	If channelPos > 0 Then
		' trim the text
		htmlResult = mid(htmlResult, channelPos)
		
		' chop off everything after </TR>
		trPos = InStr(htmlResult, "</TR>")
		htmlResult = mid(htmlResult, 1, trPos)
		backuphtml = htmlResult ' save for getting the show title
		
		tdPos = InStr(htmlResult, "<TD ")+1
		htmlResult = mid(htmlResult, tdPos)
		
		sizePos = InStr(htmlResult, "size=1>") + 7
		mPos = InStr(htmlResult, "m:")
		timeSlot = mid(htmlResult, sizePos, mPos-sizePos+2)

		temphtml = htmlResult

		Do While 0 < 1
		
			' check for another show in one cell
			brPos = InStr(temphtml, "<BR>") + 4
			fontPos = InStr(temphtml, "</font>")
			
			If (fontPos - brPos) < 2 Then
				Exit Do
			End If

			temphtml = mid(temphtml, brPos, fontPos - brPos + 7)
		
			check = InStr(temphtml, ":")
		
			If check > 0 Then

				' another show found
				timeList(i) = mid(temphtml, 1, check)
				i = i + 1

			End If
		Loop

		backuphtml = mid(backuphtml, InStr(backuphtml, timeSlot))
		endTitle = InStr(backuphtml, "</") - 1
		
		whatsOnNext2 = trimHTML(mid(backuphtml, 1, endTitle))
		Exit Function

	else
		whatsOnNext2 = "Unavailable"
		Exit Function

	End If
	
	' check if next is unknown
	If whatsOnNext = ">" & channel2 Then
		whatsOnNext2 = "Unknown"
		
	End If

End Function

Private Function timeGreaterThan(time1, time2)

	time1hr = CInt(mid(time1, 1, InStr(time1, ".")-1))
	time2hr = CInt(mid(time2, 1, InStr(time2, ".")-1))
	time1min = CInt(mid(time1, InStr(time1, ".") + 1, 2))
	time2min = CInt(mid(time2, InStr(time2, ".") + 1, 2))
	
	' fix for 12pm/am
	If time1hr = 12 Then
		time1hr = 0
	End If
	
	' 12:00pm - 12:59pm bug fix by blackout 28/04/2003 9:18PM
	If time2hr = 12 Then
		time2hr = 0
	End If

	If time1hr > time2hr Then
		' 1st time is bigger
		timeGreaterThan = True
		Exit Function
	End If
	
	If time1hr < time2hr Then
		' 2nd time is bigger
		timeGreaterThan = False
		Exit Function
	End If
	
	' must be in the same hour
	If time1min > time2min Then
		' 1st time is bigger
		timeGreaterThan = True
		Exit Function
	Else
		' 2nd time is bigger or equal
		timeGreaterThan = False
	End If

End Function

Private Function timeOfDay()

	currentHour = Hour(Time)

	if currentHour >= 18 then
		timeOfDay = "Night"
		Exit Function
	end if

	if currentHour >= 12 then
		timeOfDay = "Afternoon"
		Exit Function
	end if

	if currentHour >= 6 then
		timeOfDay = "Morning"
		Exit Function
	end if

	if currentHour >= 0 then
		timeOfDay = "LateNight"
		Exit Function
	end if

End Function

Private Function getDate()

	currentDay = Day(Date)
	currentDayOfWeek = WeekDay(Date)
	currentMonth = Month(Date)

	currentDayName = WeekDayName(currentDayOfWeek)
	currentMonthName = MonthName(currentMonth)

	' return the date in the appropriate format
	getDate = currentDayName & "_" & currentDay & "_" & currentMonthName

End Function

Private Function getYesterdaysDate()

	currentDay = Day(Date-1)
	currentDayOfWeek = WeekDay(Date-1)
	currentMonth = Month(Date)

	currentDayName = WeekDayName(currentDayOfWeek)
	currentMonthName = MonthName(currentMonth)

	' return the date in the appropriate format
	getYesterdaysDate = currentDayName & " " & currentDay & " " & currentMonthName

End Function

Private Function yesterday()
	dayOfWeek = WeekDay(Date) - 1
	If dayOfWeek < 1 Then
		dayOfWeek = 7
	End If
	yesterday = WeekDayName(dayOfWeek)
End Function

Private Function getTime()

	currentHour = Hour(Time)	
	currentMinute = Minute(Time)
	dayTime = "am"

	If currentHour >= 12 Then
		' afternoon
		if currentHour > 12 then
			currentHour = currentHour - 12
		end if

		dayTime = "pm"
	End If

	getTime = currentHour & "." & currentMinute & " " & dayTime
	
End Function


Private Function readFile(fileName)

	dim contents

	Set fs = CreateObject ("Scripting.FileSystemObject")
        If (fs.FileExists(fileName)) Then
		Set filePath = fs.GetFile(fileName)
		set File = filePath.OpenAsTextStream (1, -2)

		contents = file.readall

		File.Close
		Set filePath = nothing
		Set fs = nothing
		Set File = nothing
	Else 	
		readFile = "File doesn't exist"
		Exit Function
        End If

	' return file contents
	readFile = contents

End Function

Private Function getHTMLValue(sURL)
	Dim objXMLHTTP,HTML
	Set objXMLHTTP = CreateObject("Microsoft.XMLHTTP")
	objXMLHTTP.Open "GET", sURL, False
	objXMLHTTP.Send
	HTML = objXMLHTTP.responseBody
	Set objRS = CreateObject("ADODB.Recordset")
	objRS.Fields.Append "txt", 200, 45000, &H00000080
	objRS.Open
	objRS.AddNew
	objRS.Fields("txt").AppendChunk HTML
	getHTMLValue = objRS("txt").Value
	objRS.Close
	Set objRS = Nothing
	Set objXMLHTTP = Nothing
End Function

' ******************************
' Following function by Alderaic
' ******************************

'very simple function that will remove all html tags
Private Function TrimHTML(str)
pos_deb = InStr(1, str, "<")
Do Until pos_deb = 0
    pos_fin = InStr(pos_deb, str, ">")
    part_d = Mid(str, 1, pos_deb - 1)
    part_f = Mid(str, pos_fin + 1, Len(str) - pos_fin)
    str = part_d & part_f
    pos_deb = InStr(1, str, "<")
Loop
TrimHTML = str
End Function