'------------------------------------------------------------------------------
'  NZTV.vbs (v1.11) 
'------------------------------------------------------------------------------
'
' This script rips information from http://home.nzcity.co.nz/tvnow/tvguide.asp?
' to work out what is current showing on TV and what is coming up next.
'
' This script currently only works with five free to air NZ channels:
'      - TVOne
'      - TV2
'      - TV3
'      - TV4
'      - Prime
'
' If you know of another NZ TV listing site that is a little more reliable but 
' of similar format, let me know!
' 
' Also, the Prime TV listing isn't always reliable as the site doesn't seem to
' update its Prime listings as often as the more popular channels.
'
' Feel free to change the user variables to suit your Samurize config :)
'
' NOTES:
'
' - Execute the "generateListing" function to update your TV listings. Ignore 
'   any warnings from antivirus software that this is a malicious script (it
'   just writes a small .tmp file to your Configs directory to store the TV
'   listings)
'
' Version history:
'
' v1.11: Fixed bug where if a channel had no next listing at all, the script
'	would report an error. If now returns "N/A" for that channel listing.
'
' v1.1: Changed the script to read/write a .tmp file to disk (the script no
'       longer has to retreive the HTML content for every channel listing; it
'       only has to do it once via the generateListing function)
'
'				                - NeM (nem@paradise.net.nz)
'------------------------------------------------------------------------------

' ---- User variables ----

' Set whether you want the TV show coming up next to have its start time 
' appended to it. TRUE = append, FALSE = do not

SHOW_STARTTIMES = TRUE

' ------------------------

FILE_NAME = "NZTV.tmp"

Function getTV1now()
	getTV1now=getNowListing(1)
End Function

Function getTV2now()
	getTV2now=getNowListing(2)
End Function

Function getTV3now()
	getTV3now=getNowListing(3)
End Function

Function getTV4now()
	getTV4now=getNowListing(4)
End Function

Function getPrimenow()
	getPrimenow=getNowListing(5)
End Function

Function getTV1next()
	getTV1next=getNextListing(1)
End Function

Function getTV2next()
	getTV2next=getNextListing(2)
End Function

Function getTV3next()
	getTV3next=getNextListing(3)
End Function

Function getTV4next()
	getTV4next=getNextListing(4)
End Function

Function getPrimenext()
	getPrimenext=getNextListing(5)
End Function

Function generateListing()

	dim fs,f,htmlResult

	htmlResult = ReturnHTML("http://home.nzcity.co.nz/tvnow/tvguide.asp")

	set fs=CreateObject("Scripting.FileSystemObject")
	set f=fs.CreateTextFile(FILE_NAME,true)
	f.write(htmlResult)
	f.close
	set f=nothing
	set fs=nothing

End Function

Private Function readFile(fileName)

	dim contents

	Set fs = CreateObject ("Scripting.FileSystemObject")
        If (fs.FileExists(fileName)) Then
		Set filePath = fs.GetFile(fileName)
		set File = filePath.OpenAsTextStream (1, -2)

		contents = file.readall

		File.Close ' Closes the file
		Set filePath = nothing
		Set fs = nothing
		Set File = nothing
	Else 
		Exit Function
        End If

	' return file contents
	readFile = contents

End Function


Private Function getFirstListing(Channel)

	dim htmlResult,output,strAllInfo, junk

	htmlResult = readFile(FILE_NAME)

	' first cut everything before <b>TVNOW</b>
	strAllInfo = Mid(htmlResult, InStr(htmlResult, "<b>TVNOW</b>"))

	For i=1 to Channel

		' now, cut before the first '<td ' to check for blank entry
		strAllInfo = Mid(strAllInfo, InStr(strAllInfo, "<td ")+4, Len(strAllInfo))


	Next

	junk = Mid(strAllInfo, 1, InStr(strAllInfo, ">")-1)


	If Instr(junk, "top") Then

		' now, cut before the first '<td ' to check for blank entry
		strAllInfo = Mid(strAllInfo, InStr(strAllInfo, "size=-1>")+8, Len(strAllInfo))

		' now we got the TV show name with junk on the end... remove the junk
		output = Mid(strAllInfo, 1, InStr(strAllInfo, "<font")-1)

		getFirstListing = output

	Else

		' No listing shown for the current time
		getFirstListing = "N/A"
	End If
End Function


Private Function getNowListing(Channel)

	dim htmlResult,output,strAllInfo,junk,fs,file

	htmlResult = readFile(FILE_NAME)

	' first cut everything before <b>TVNOW</b>
	strAllInfo = Mid(htmlResult, InStr(htmlResult, "<b>TVNOW</b>"))

	' cut everything before the bgcolor for what's next:
	strAllInfo = Mid(strAllInfo, InStr(strAllInfo, "bgcolor=#FFF5C0>"))
	strAllInfo = Mid(strAllInfo, InStr(strAllInfo, "<b>"))

	For i=1 to Channel

		' now, cut before the first '<td ' to check for blank entry
		strAllInfo = Mid(strAllInfo, InStr(strAllInfo, "<td ")+4, Len(strAllInfo))


	Next

	junk = Mid(strAllInfo, 1, InStr(strAllInfo, ">")-1)


	If Instr(junk, "top") Then

		' cut before the first '<b>'
		strAllInfo = Mid(strAllInfo, InStr(strAllInfo, "<b>")+3, Len(strAllInfo))

		' now we have the TV show name with junk on the end... remove the junk
		output = Mid(strAllInfo, 1, InStr(strAllInfo, "</b>")-1)		

		getNowListing = output

	Else

		' No listing shown for the current time
		getNowListing = getFirstListing(Channel)


	End If

End Function



Private Function getNextListing(Channel)

	dim htmlResult,output,strAllInfo,junk,startTime,fs,file

	htmlResult = readFile(FILE_NAME)

	' first cut everything before <b>TVNOW</b>
	strAllInfo = Mid(htmlResult, InStr(htmlResult, "<b>TVNOW</b>"))

	' cut everything before the bgcolor for what's next:
	strAllInfo = Mid(strAllInfo, InStr(strAllInfo, "bgcolor=#FFF5C0>"))
	strAllInfo = Mid(strAllInfo, InStr(strAllInfo, "bgcolor=#f5f5f5>"))
	strAllInfo = Mid(strAllInfo, InStr(strAllInfo, "-1><b>"))


	For j = 1 to 100

		startTime = Mid(strAllInfo, 7, InStr(strAllInfo, "</b>")-7)

		For i=1 to Channel

			' now, cut before the first '<td ' to check for blank entry
			strAllInfo = Mid(strAllInfo, InStr(strAllInfo, "<td ")+4, Len(strAllInfo))


		Next

		junk = Mid(strAllInfo, 1, InStr(strAllInfo, ">")-1)


		If Instr(junk, "top") Then

			' now, cut before the first 'size=-1'
			strAllInfo = Mid(strAllInfo, InStr(strAllInfo, "size=-1>")+8, Len(strAllInfo))

			' now we got the TV show name with junk on the end... remove the junk
			output = Mid(strAllInfo, 1, InStr(strAllInfo, "<")-1)		

			If SHOW_STARTTIMES = TRUE Then

				' add the start time
				output = output & " (" & startTime & ")"

			End If

			getNextListing = output
			Exit Function

		Else

			If InStr(strAllInfo, "-1><b>") <= 0 Then
				' There are no more TV listings for that channel
				Exit For
			End If

			' No listing shown for the current time; try the next time
			strAllInfo = Mid(strAllInfo, InStr(strAllInfo, "-1><b>"))

		End If

	Next

	getNextListing = "N/A"

End Function


Private Function ReturnHTML(sURL)
	Dim objXMLHTTP,HTML
	Set objXMLHTTP = CreateObject("Microsoft.XMLHTTP")
	objXMLHTTP.Open "GET", sURL, False
	objXMLHTTP.Send
	HTML = objXMLHTTP.responseBody
	Set objRS = CreateObject("ADODB.Recordset")
	objRS.Fields.Append "txt", 200, 45000, &H00000080
	objRS.Open
	objRS.AddNew
	objRS.Fields("txt").AppendChunk HTML
	ReturnHTML = objRS("txt").Value
	objRS.Close
	Set objRS = Nothing
	Set objXMLHTTP = Nothing
End Function
