'Extended Properties Information VBScript
'Version 1.5
'Created 4th June 2002
'Last Modified 19th March 2003
'Copyright 2003, Rowan Gillson
'Not redistributable without express permission from author.
'Suitable for Windows 2000/Windows XP only.
'
'
'comments to r_gillson@hotmail.com or ICQ # 14894674

on error resume Next

Set NetworkInfoSet = CreateObject("Wscript.Network")

'-----------------------------------------------------
'WMI Class Enumerator
'-----------------------------------------------------
Private Sub GetWMI(ComputerName, WMIArray, WMIQuery)

Set WMIClass = GetObject("winmgmts:" _
    & "{impersonationLevel=impersonate}!\\" & ComputerName & "\root\cimv2")
Set WMIArray = WMIClass.ExecQuery(WMIQuery)

End Sub

'-----------------------------------------------------



'-----------------------------------------------------
'Network information functions
'-----------------------------------------------------
'Displays external IP address
Function IPAddress(ComputerName)

Call GetWMI(ComputerName, IPConfigSet, "Select * from Win32_NetworkAdapterConfiguration where IPEnabled=TRUE")

For Each objIPInfo in IPConfigSet
    IPAddress = objIPInfo.IPAddress(0)
Next

End Function

'-----------------------------------------------------
'Displays logged on username
Function UserName()
    UserName = NetworkInfoSet.UserName
End Function

'-----------------------------------------------------
'Displays computers network name
Function ComputerName()
    ComputerName = NetworkInfoSet.ComputerName
End Function

'-----------------------------------------------------
'Displays domain name for network users, if no domain, displays machine name
Function DomainName()
    DomainName = NetworkInfoSet.UserDomain
End Function

'-----------------------------------------------------
'Displays current Primary Group for domain users only, will not work for non-domain computers
Function PrimaryGroup()

    Dim objUser 
    Dim Group, aGroup, PrimaryGroupRID
   
    Set objUser = GetObject("WinNT://" & NTDomain & "/" & NTUser & ",user")
    PrimaryGroupRID = objUser.Get("PrimaryGroupID")
    For Each Group in objUser.Groups
    aGroup = Group.Name
    If Rid(aGroup) = PrimaryGroupRID then
         PrimaryGroup = aGroup
         Exit Function
    End If
    Next

End Function

Private Function Rid(aGroup)
   
    Dim objGroup, Sid, sTmp, x, b
   
    Set objGroup = GetObject("WinNT://" & NTDomain & "/" & aGroup & ",group")
    Sid = objGroup.Get("objectSID")
    sTmp = ""
    For x = UBound(Sid) to UBound(Sid)-3 Step -1  
        b = AscB(MidB(SID, x + 1))                 
        sTmp = sTmp & Hex(b \ 16) & Hex(b And 15)  
    Next
    Rid = Clng("&H" & sTmp)                       
    Set objGroup = Nothing

End Function

Private Function NTDomain

    Dim varDomain
    Set varDomain = CreateObject("Wscript.Network")
    NTDomain = varDomain.UserDomain

End Function

Private Function NTUser

    Dim varUser
    Set varUser = CreateObject("Wscript.Network")
    NTUser = varUser.UserName
    
End Function

'-----------------------------------------------------
'Displays workgroup or domain depending on membership to either.
Function WorkgroupName(ComputerName)

Call GetWMI(ComputerName, SystemInfoSet, "Select * from Win32_ComputerSystem")

For Each sWGVar in SystemInfoSet
    sWG = sWGVar.Domain(0)
    If IsNull(sWG) Then
    Else
    	WorkgroupName = sWG
    End If
Next

End Function

'-----------------------------------------------------
'Displays external IP address
Function DomainRole(ComputerName)

Call GetWMI(ComputerName, SystemInfoSet, "Select * from Win32_ComputerSystem")

For Each objDomainInfo in SystemInfoSet
	sDomainRoleVar = objDomainInfo.DomainRole
Next

Select Case sDomainRoleVar
        Case 0: DomainRole = "Standalone Workstation"        
		Case 1: DomainRole = "Member Workstation"
        Case 2: DomainRole = "Standalone Server"        
		Case 3: DomainRole = "Member Server"
        Case 4: DomainRole = "Backup Domain Controller"        	
		Case 5: DomainRole = "Primary Domain Controller"    
	End Select

End Function

'-----------------------------------------------------


'-----------------------------------------------------
'Video display information functions
'-----------------------------------------------------
'Displays description of video card
Function VideoCardDescription(ComputerName)

Call GetWMI(ComputerName, VideoDeviceSet, "Select * from Win32_VideoController where DeviceID='VideoController1'")

For Each objVideoInfo in VideoDeviceSet
	VideoCardDescription = objVideoInfo.Description
Next

End Function

'-----------------------------------------------------
'Displays video card RAM amount
Function VideoRAM(ComputerName)

Call GetWMI(ComputerName, VideoDeviceSet, "Select * from Win32_VideoController where DeviceID='VideoController1'")

For Each objVideoInfo in VideoDeviceSet
	VideoRAM = objVideoInfo.AdapterRAM/1048576
Next

End Function

'-------------------------------------------------------
'Displays current screen resolution
Function VideoResolution(ComputerName)

Call GetWMI(ComputerName, VideoDeviceSet, "Select * from Win32_VideoController where DeviceID='VideoController1'")

For Each objVideoInfo in VideoDeviceSet
	VideoResolution = objVideoInfo.CurrentHorizontalResolution & _
	" x " & objVideoInfo.CurrentVerticalResolution
Next

End Function

'-----------------------------------------------------
'Displays current refresh rate of video card in MHZ
Function VideoRefreshRateMHz(ComputerName)

Call GetWMI(ComputerName, VideoDeviceSet, "Select * from Win32_VideoController where DeviceID='VideoController1'")

For Each objVideoInfo in VideoDeviceSet
	VideoRefreshRateMHz = objVideoInfo.CurrentRefreshRate
Next

End Function

'-----------------------------------------------------
'Displays current video driver version
Function VideoDriverVersion(ComputerName)

Call GetWMI(ComputerName, VideoDeviceSet, "Select * from Win32_VideoController where DeviceID='VideoController1'")

For Each objVideoInfo in VideoDeviceSet
	VideoDriverVersion = objVideoInfo.DriverVersion
Next

End Function

'-----------------------------------------------------


'-----------------------------------------------------
'CPU Information Functions
'-----------------------------------------------------
'Displays CPU Description
Function CPUDescription(ComputerName)

Call GetWMI(ComputerName, CPUInfoSet, "Select * from Win32_Processor")

For Each objProcessors in CPUInfoSet
	CPUDescription = objProcessors.Name
Next

End Function

'-----------------------------------------------------
'Displays CPU Clock speed
Function CPUSpeed(ComputerName)

Call GetWMI(ComputerName, CPUInfoSet, "Select * from Win32_Processor")

For Each objProcessors in CPUInfoSet
	CPUSpeed = objProcessors.MaxClockSpeed & " MHz"
Next

End Function

'-----------------------------------------------------
'Displays CPU FSB speed
Function CPUFSB(ComputerName)

Call GetWMI(ComputerName, CPUInfoSet, "Select * from Win32_Processor")

For Each objProcessors in CPUInfoSet
	CPUFSB = objProcessors.ExtClock & " MHz"
Next

End Function

'-----------------------------------------------------
'Displays CPU Multiplier speed
Function CPUMultiplier(ComputerName)

Call GetWMI(ComputerName, CPUInfoSet, "Select * from Win32_Processor")

For Each objProcessors in CPUInfoSet
	CPUMultiplier = Round(objProcessors.MaxClockSpeed / objProcessors.ExtClock,1)
Next

End Function


'-----------------------------------------------------
'Displays CPU Model
Function CPUModel(ComputerName)

Call GetWMI(ComputerName, CPUInfoSet, "Select * from Win32_Processor")

For Each objProcessors in CPUInfoSet
	CPUModel = objProcessors.Caption
Next

End Function

'-----------------------------------------------------
'Displays number of CPU's in system
Function CPUProcessors(ComputerName)

Call GetWMI(ComputerName, SystemInfoSet, "Select * from Win32_ComputerSystem")

For Each objProcessors in SystemInfoSet
	CPUProcessors = objProcessors.NumberOfProcessors
Next

End Function

'-----------------------------------------------------


'-----------------------------------------------------
'Environment Information Functions
'-----------------------------------------------------
'Displays OS build number
Function OSBuildNumber(ComputerName)

Call GetWMI(ComputerName, OSInfoSet, "Select * from Win32_OperatingSystem")

For Each objOperatingSystem in OSInfoSet
	OSBuildNumber = objOperatingSystem.BuildNumber
Next

End Function

'-----------------------------------------------------
'Displays OS build type
Function OSBuildType(ComputerName)

Call GetWMI(ComputerName, OSInfoSet, "Select * from Win32_OperatingSystem")

For Each objOperatingSystem in OSInfoSet
	OSBuildType = objOperatingSystem.BuildType
Next

End Function

'-----------------------------------------------------
'Displays Service Pack version info
Function OSSrvPack(ComputerName)

Call GetWMI(ComputerName, OSInfoSet, "Select * from Win32_OperatingSystem")

For Each objOperatingSystem in OSInfoSet
	OSSrvPack = objOperatingSystem.CSDVersion
Next

End Function

'-----------------------------------------------------
'Displays OS Name
Function OSName(ComputerName)

Call GetWMI(ComputerName, OSInfoSet, "Select * from Win32_OperatingSystem")

For Each objOperatingSystem in OSInfoSet
	OSName = objOperatingSystem.Caption
Next

End Function

'-----------------------------------------------------